﻿using System;
using NetRuntimeSystem = System;
using System.ComponentModel;
using NetOffice.Attributes;

namespace NetOffice.OfficeApi
{
	/// <summary>
	/// DispatchInterface MsoDebugOptions 
	/// SupportByVersion Office, 9,10,11,12,14,15,16
	/// </summary>
	[SupportByVersion("Office", 9,10,11,12,14,15,16)]
	[EntityType(EntityType.IsDispatchInterface)]
 	public class MsoDebugOptions : _IMsoDispObj
	{
		#pragma warning disable

		#region Type Information

		/// <summary>
		/// Instance Type
		/// </summary>
		[EditorBrowsable(EditorBrowsableState.Advanced), Browsable(false), Category("NetOffice"), CoreOverridden]
		public override Type InstanceType
		{
			get
			{
				return LateBindingApiWrapperType;
			}
		}

        private static Type _type;

		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        public static Type LateBindingApiWrapperType
        {
            get
            {
                if (null == _type)
                    _type = typeof(MsoDebugOptions);
                return _type;
            }
        }
        
        #endregion
        
		#region Ctor

		/// <param name="factory">current used factory core</param>
		/// <param name="parentObject">object there has created the proxy</param>
		/// <param name="proxyShare">proxy share instead if com proxy</param>
		public MsoDebugOptions(Core factory, ICOMObject parentObject, COMProxyShare proxyShare) : base(factory, parentObject, proxyShare)
		{
		}

		///<param name="factory">current used factory core</param>
		///<param name="parentObject">object there has created the proxy</param>
        ///<param name="comProxy">inner wrapped COM proxy</param>
		public MsoDebugOptions(Core factory, ICOMObject parentObject, object comProxy) : base(factory, parentObject, comProxy)
		{
			
		}

        ///<param name="parentObject">object there has created the proxy</param>
        ///<param name="comProxy">inner wrapped COM proxy</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public MsoDebugOptions(ICOMObject parentObject, object comProxy) : base(parentObject, comProxy)
		{
		}
		
		///<param name="factory">current used factory core</param>
		///<param name="parentObject">object there has created the proxy</param>
        ///<param name="comProxy">inner wrapped COM proxy</param>
        ///<param name="comProxyType">Type of inner wrapped COM proxy"</param>
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public MsoDebugOptions(Core factory, ICOMObject parentObject, object comProxy, NetRuntimeSystem.Type comProxyType) : base(factory, parentObject, comProxy, comProxyType)
		{

		}

		///<param name="parentObject">object there has created the proxy</param>
        ///<param name="comProxy">inner wrapped COM proxy</param>
        ///<param name="comProxyType">Type of inner wrapped COM proxy"</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public MsoDebugOptions(ICOMObject parentObject, object comProxy, NetRuntimeSystem.Type comProxyType) : base(parentObject, comProxy, comProxyType)
		{
		}
		
		///<param name="replacedObject">object to replaced. replacedObject are not usable after this action</param>
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public MsoDebugOptions(ICOMObject replacedObject) : base(replacedObject)
		{
		}
		
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public MsoDebugOptions() : base()
		{
		}
		
		/// <param name="progId">registered progID</param>
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public MsoDebugOptions(string progId) : base(progId)
		{
		}
		
		#endregion
		
		#region Properties

		/// <summary>
		/// SupportByVersion Office 9, 10, 11, 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Office", 9,10,11,12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public Int32 FeatureReports
		{
			get
			{
				return Factory.ExecuteInt32PropertyGet(this, "FeatureReports");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "FeatureReports", value);
			}
		}

		/// <summary>
		/// SupportByVersion Office 10, 11, 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Office", 10,11,12,14,15,16)]
		public bool OutputToDebugger
		{
			get
			{
				return Factory.ExecuteBoolPropertyGet(this, "OutputToDebugger");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "OutputToDebugger", value);
			}
		}

		/// <summary>
		/// SupportByVersion Office 10, 11, 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Office", 10,11,12,14,15,16)]
		public bool OutputToFile
		{
			get
			{
				return Factory.ExecuteBoolPropertyGet(this, "OutputToFile");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "OutputToFile", value);
			}
		}

		/// <summary>
		/// SupportByVersion Office 10, 11, 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Office", 10,11,12,14,15,16)]
		public bool OutputToMessageBox
		{
			get
			{
				return Factory.ExecuteBoolPropertyGet(this, "OutputToMessageBox");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "OutputToMessageBox", value);
			}
		}

		/// <summary>
		/// SupportByVersion Office 12, 14, 15, 16
		/// Get
		/// Unknown COM Proxy
		/// </summary>
		[SupportByVersion("Office", 12,14,15,16), ProxyResult]
		public object UnitTestManager
		{
			get
			{
				return Factory.ExecuteReferencePropertyGet(this, "UnitTestManager");
			}
		}

		#endregion

		#region Methods

		/// <summary>
		/// SupportByVersion Office 15,16
		/// </summary>
		/// <param name="bstrTagToIgnore">string bstrTagToIgnore</param>
		[SupportByVersion("Office", 15, 16)]
		public void AddIgnoredAssertTag(string bstrTagToIgnore)
		{
			 Factory.ExecuteMethod(this, "AddIgnoredAssertTag", bstrTagToIgnore);
		}

		/// <summary>
		/// SupportByVersion Office 15,16
		/// </summary>
		/// <param name="bstrTagToIgnore">string bstrTagToIgnore</param>
		[SupportByVersion("Office", 15, 16)]
		public void RemoveIgnoredAssertTag(string bstrTagToIgnore)
		{
			 Factory.ExecuteMethod(this, "RemoveIgnoredAssertTag", bstrTagToIgnore);
		}

		#endregion

		#pragma warning restore
	}
}
